<?php
/*======================================================================*\
|| #################################################################### ||
|| #     3,0			                          # ||
|| # pi9s - www.shneler.com/vb                                            # ||
|| #################################################################### ||
\*======================================================================*/

function handle_bbcode_url_vbanonymizer(&$parser, $text, $link)
{
	$rightlink = trim($link);
	if (empty($rightlink))
	{
		// no option -- use param
		$rightlink = trim($text);
	}
	$rightlink = str_replace(array('`', '"', "'", '['), array('&#96;', '&quot;', '&#39;', '&#91;'), $parser->strip_smilies($rightlink));

	// remove double spaces -- fixes issues with wordwrap
	$rightlink = str_replace('  ', '', $rightlink);

	if (!preg_match('#^[a-z0-9]+(?<!about|javascript|vbscript|data):#si', $rightlink))
	{
		$rightlink = "http://$rightlink";
	}

	if (!trim($link) OR str_replace('  ', '', $text) == $rightlink)
	{
		$tmp = unhtmlspecialchars($rightlink);
		if (vbstrlen($tmp) > 55 AND $parser->is_wysiwyg() == false)
		{
			$text = htmlspecialchars_uni(substr($tmp, 0, 36) . '...' . substr($tmp, -14));
		}
		else
		{
			// under the 55 chars length, don't wordwrap this
			$text = str_replace('  ', '', $text);
		}
	}

	// parse our URL
	$parsedurl = @parse_url($rightlink);

	// check ignored protocols
	if (!($parsedurl['scheme'] AND $parsedurl['host']) OR in_array($parsedurl['scheme'], $parser->vbanonymizer['ignored_protocols']))
	{
		// standard URL hyperlink
		return "<a href=\"$rightlink\" target=\"_blank\">$text</a>";
	}

	// check whitelisted domains
	foreach ($parser->vbanonymizer['whitelist'] AS $domain)
	{
		if ($domain == $parsedurl['host'] OR ($domain[0] == '.' AND strpos($parsedurl['host'], $domain) == (vbstrlen($parsedurl['host']) - vbstrlen($domain))))
		{
			// standard URL hyperlink
			return "<a href=\"$rightlink\" target=\"_blank\">$text</a>";
		}
	}

	// build new path
	$rightlink = (($parser->registry->options['vbanonymizer_scriptpath']) ? $parser->registry->options['vbanonymizer_scriptpath'] : $parser->registry->options['bburl']) . '/' . $parser->registry->options['vbanonymizer_scriptname'] . '.php?' . $parser->registry->session->vars['sessionurl'] . 'url=' . rawurlencode(str_replace('&amp;', '&', $rightlink));

	// add no follow attribute
	if ($parser->registry->options['vbanonymizer_nofollow'])
	{
		$nofollow = ' rel="nofollow"';
	}

	// standard URL hyperlink
	return "<a href=\"$rightlink\" target=\"_blank\"$nofollow>$text</a>";
}
?>
